/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2477;
import net.minecraft.class_2960;
import net.minecraft.class_5458;
import org.apache.commons.lang3.text.WordUtils;
import potionstudios.byg.BYG;

public class LangFileGenerator {
    public static final Map<Class<?>, String> TYPE_ID = (Map)class_156.method_654(new HashMap(), map -> {
        map.put(class_1299.class, "entity");
        map.put(class_1959.class, "biome");
        map.put(class_2248.class, "block");
        map.put(class_1792.class, "item");
        map.put(class_1291.class, "effect");
    });
    public static final Map<String, String> MISC_LANG_ENTRIES = (Map)class_156.method_654(new TreeMap(), map -> {
        InputStream resourceAsStream = class_2477.class.getResourceAsStream("/assets/byg/lang/en_us_misc.json");
        if (resourceAsStream != null) {
            map.putAll((Map)new Gson().fromJson((Reader)new InputStreamReader(resourceAsStream), TreeMap.class));
        }
    });

    public static void createLangFile(Path path) {
        TreeMap<String, String> lang = new TreeMap<String, String>(MISC_LANG_ENTRIES);
        for (class_2378 registry : class_2378.field_11144) {
            LangFileGenerator.yes(registry, lang);
        }
        for (class_2378 registry : class_5458.field_25926) {
            LangFileGenerator.yes(registry, lang);
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(lang).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            BYG.LOGGER.error(e.toString());
        }
    }

    private static <T> void yes(class_2378<T> registry, Map<String, String> map) {
        for (Object value : registry) {
            class_2960 key = registry.method_10221(value);
            if (!key.method_12836().equals("byg")) continue;
            TYPE_ID.forEach((aClass, s) -> {
                if (aClass.isAssignableFrom(value.getClass())) {
                    String id = class_156.method_646((String)s, (class_2960)key);
                    map.put(id, WordUtils.capitalize((String)key.method_12832().replace("_", " ")));
                }
            });
        }
    }
}

